#make sure pyvisa is installed via "pip install pyvisa"
#make sure NIVISA or R&S VISA is installed on the system: https://www.ni.com/en-ca/support/downloads/drivers/download.ni-visa.html#346210 or https://inst.santec.com/resources/programming
import pyvisa as vs
import time

#SAMPLE
###########################################################################
SANTEC_VID = 'USB0::0x2428'  # 0x2428 is the santec vendor ID (VID)

rm = vs.ResourceManager()
instruments=rm.list_resources()
print(instruments)
#see if any santec USB instruments are present
if(any(s.startswith(SANTEC_VID) for s in instruments)):
    r = [s for s in instruments if s.startswith(SANTEC_VID)]
    if(len(r)>0):
        print("USB device found. Connecting to",r[0])
        instrument = rm.open_resource(r[0], open_timeout=5000)
else:
    #if no USB instruments, ask for IP address
    ip=input("Enter IP Address: ")
    TCP_INST="TCPIP::"+ip+"::5025::SOCKET"
    instrument = rm.open_resource(TCP_INST, open_timeout=5000)

#important to set these parameters for santec devices.
#\n is required as a read/write termination
instrument.timeout = 15000
instrument.query_delay = 0
instrument.write_termination = '\n'
instrument.read_termination = '\n'
time.sleep(0.5)

#run any SCPI commands here.
#SPIC commands for particular instruments are listed in the user manual.
print(instrument.query("*IDN?"))

#when done with instrument, close the connection
instrument.close()
rm.close()